import Utilities.waveform_creator as wc
import Utilities.gui_creator as gc
import Utilities.plot_creator as pc


def calculate_plot_waveform():
    
    num_string = gc.get_control_string(var_ent_1)
    alpha_string = gc.get_control_string(var_ent_2)

    num = int(num_string)
    alpha = float(alpha_string)
    
    delta_t = 0.001
    samp_freq = 1/delta_t

    t = wc.create_time_data(num, samp_freq)
    v = wc.falling_in_air(num, delta_t, alpha)
    
    pc.update_plot(ax,canvas, t, v, label_x, label_y,
                   marker='-')


    return

title = 'Falling In Air'
label_x,label_y = 'Time (s)','Speed (m/s)'

root = gc.create_window(title)
control_box,right_frame = gc.create_frames(root)

var_ent_1 = gc.create_control(control_box, 'Number of Samples')
var_ent_2 = gc.create_control(control_box, 'Alpha')


ax,canvas = pc.create_plot(right_frame)
pc.update_plot(ax, canvas, [], [], label_x, label_y)

gc.action_button(control_box, label='Submit',
                 action= calculate_plot_waveform)

root.mainloop()
